package jamezo97.clonecraft.network;

import jamezo97.clonecraft.entity.clone.EntityClone;

import java.util.Random;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import cpw.mods.fml.relauncher.Side;

public class Handler8CloneClones extends Handler{
	
	@Value(id = 0)
	int entityId;
	@Value(id = 1)
	int amount;

	public Handler8CloneClones(){

	}

	public Handler8CloneClones(EntityClone clone, int amount){
		this.entityId = clone.entityId;
		this.amount = amount;
	}

	@Override
	public void handle(Side side, INetworkManager manager, EntityPlayer player) {
		if(side == Side.SERVER){
			if(amount > 50){
				amount = 50;
			}
			if(amount > 0){
				if(player.capabilities.isCreativeMode){
					Random r = new Random();
					EntityClone toCopy = getCloneOnServer(entityId, player.worldObj);
					if(toCopy != null && toCopy.canUseThisEntity(player.username)){
						NBTTagCompound cloneTag = new NBTTagCompound();
						toCopy.writeToNBT(cloneTag);
						for(int a = 0; a < amount; a++){
							EntityClone newClone = new EntityClone(toCopy.worldObj);
							newClone.readFromNBT(cloneTag);
							newClone.posX += (r.nextFloat()-.5f) / 10.0f;
							newClone.posZ += (r.nextFloat()-.5f) / 10.0f;
							newClone.worldObj.spawnEntityInWorld(newClone);
						}
					}
				}
				
			}
		}
	}



}
